<?php
/**
 * لوحة إعدادات مصادقة AT Studio
 * 
 * @package AT_Studio_Auth
 */

if (!defined('ABSPATH')) exit;

class AT_Studio_Auth_Settings {
    public function __construct() {
        add_action('admin_menu', [$this, 'add_admin_menu']);
        add_action('admin_init', [$this, 'register_settings']);
    }

    /**
     * إضافة قائمة الإعدادات
     */
    public function add_admin_menu() {
        add_options_page(
            'إعدادات مصادقة AT Studio',
            'مصادقة AT Studio',
            'manage_options',
            'at-studio-auth-settings',
            [$this, 'render_settings_page']
        );
    }

    /**
     * تسجيل الإعدادات
     */
    public function register_settings() {
        // تسجيل إعدادات Discord
        register_setting('at_studio_auth_settings', 'at_studio_discord_client_id');
        register_setting('at_studio_auth_settings', 'at_studio_discord_client_secret');

        // تسجيل إعدادات Google
        register_setting('at_studio_auth_settings', 'at_studio_google_client_id');
        register_setting('at_studio_auth_settings', 'at_studio_google_client_secret');
        
        // تسجيل إعدادات الحماية
        register_setting('at_studio_auth_settings', 'at_studio_recaptcha_site_key');
        register_setting('at_studio_auth_settings', 'at_studio_recaptcha_secret_key');
        register_setting('at_studio_auth_settings', 'at_studio_hide_login_buttons');
        
        // تسجيل إعدادات التحكم الفردي
        register_setting('at_studio_auth_settings', 'at_studio_hide_discord_button');
        register_setting('at_studio_auth_settings', 'at_studio_hide_google_button');
        register_setting('at_studio_auth_settings', 'at_studio_import_avatar');
        
        // إضافة قسم Discord
        add_settings_section(
            'at_studio_discord_section',
            'إعدادات مصادقة Discord',
            [$this, 'render_discord_section'],
            'at-studio-auth-settings'
        );

        // إضافة قسم Google
        add_settings_section(
            'at_studio_google_section',
            'إعدادات مصادقة Google',
            [$this, 'render_google_section'],
            'at-studio-auth-settings'
        );
        
        // إضافة قسم الحماية
        add_settings_section(
            'at_studio_security_section',
            'إعدادات الحماية',
            [$this, 'render_security_section'],
            'at-studio-auth-settings'
        );

        // إضافة حقول Discord
        add_settings_field(
            'at_studio_discord_client_id',
            'معرف التطبيق (Client ID)',
            [$this, 'render_discord_client_id_field'],
            'at-studio-auth-settings',
            'at_studio_discord_section'
        );

        add_settings_field(
            'at_studio_discord_client_secret',
            'الرمز السري (Client Secret)',
            [$this, 'render_discord_client_secret_field'],
            'at-studio-auth-settings',
            'at_studio_discord_section'
        );

        // إضافة حقول Google
        add_settings_field(
            'at_studio_google_client_id',
            'معرف التطبيق (Client ID)',
            [$this, 'render_google_client_id_field'],
            'at-studio-auth-settings',
            'at_studio_google_section'
        );
        
        // إضافة حقول الحماية
        add_settings_field(
            'at_studio_recaptcha_site_key',
            'مفتاح موقع reCAPTCHA',
            [$this, 'render_recaptcha_site_key_field'],
            'at-studio-auth-settings',
            'at_studio_security_section'
        );
        
        add_settings_field(
            'at_studio_hide_login_buttons',
            'إخفاء أزرار المصادقة في صفحة تسجيل الدخول',
            [$this, 'render_hide_login_buttons_field'],
            'at-studio-auth-settings',
            'at_studio_security_section'
        );
        
        add_settings_field(
            'at_studio_recaptcha_secret_key',
            'المفتاح السري reCAPTCHA',
            [$this, 'render_recaptcha_secret_key_field'],
            'at-studio-auth-settings',
            'at_studio_security_section'
        );

        add_settings_field(
            'at_studio_google_client_secret',
            'الرمز السري (Client Secret)',
            [$this, 'render_google_client_secret_field'],
            'at-studio-auth-settings',
            'at_studio_google_section'
        );
        
        // إضافة قسم التحكم الفردي
        add_settings_section(
            'at_studio_control_section',
            'التحكم في عرض أزرار المصادقة',
            [$this, 'render_control_section'],
            'at-studio-auth-settings'
        );
        
        // إضافة حقول التحكم الفردي
        add_settings_field(
            'at_studio_hide_discord_button',
            'إخفاء زر Discord',
            [$this, 'render_hide_discord_button_field'],
            'at-studio-auth-settings',
            'at_studio_control_section'
        );
        
        add_settings_field(
            'at_studio_hide_google_button',
            'إخفاء زر Google',
            [$this, 'render_hide_google_button_field'],
            'at-studio-auth-settings',
            'at_studio_control_section'
        );
        
        add_settings_field(
            'at_studio_import_avatar',
            'استيراد الصورة الشخصية',
            [$this, 'render_import_avatar_field'],
            'at-studio-auth-settings',
            'at_studio_control_section'
        );
    }

    /**
     * عرض صفحة الإعدادات
     */
    public function render_settings_page() {
        ?>
        <div class="wrap">
            <h1>إعدادات مصادقة AT Studio</h1>
            <form method="post" action="options.php">
                <?php
                settings_fields('at_studio_auth_settings');
                do_settings_sections('at-studio-auth-settings');
                submit_button();
                ?>
            </form>
            
            <div style="margin-top:60px;text-align:center;">
                <img src="<?php echo plugins_url('../assets/at-studio-logo.png', __FILE__); ?>" alt="AT Studio" width="400">
                <p>تم تطوير هذه الإضافة بواسطة <a href="https://atstudio.online" target="_blank">AT Studio</a></p>
            </div>
            
            <div style="margin-top: 80px;">
                <h2><?php _e('تعليمات الاستخدام', 'at-studio-auth'); ?></h2>
                <div style="background: #f9f9f9; padding: 40px; border-radius: 10px;">
                    <h3><?php _e('كيفية إعداد المصادقة عبر دسكورد', 'at-studio-auth'); ?></h3>
                    <ol>
                        <li><?php _e('قم بإنشاء تطبيق جديد في <a href="https://discord.com/developers/applications" target="_blank">بوابة مطوري دسكورد</a>', 'at-studio-auth'); ?></li>
                        <li><?php _e('انسخ معرف التطبيق (Client ID) والرمز السري (Client Secret) وأدخلهما في الحقول أعلاه', 'at-studio-auth'); ?></li>
                        <li><?php printf(__('أضف رابط إعادة التوجيه (Redirect URI) التالي: <code>%s/?action=discord-callback</code>', 'at-studio-auth'), site_url()); ?></li>
                        <li><?php _e('احفظ الإعدادات', 'at-studio-auth'); ?></li>
                    </ol>
                    
                    <h3><?php _e('كيفية إعداد المصادقة عبر قوقل', 'at-studio-auth'); ?></h3>
                    <ol>
                        <li><?php _e('قم بإنشاء مشروع جديد في <a href="https://console.developers.google.com/" target="_blank">وحدة تحكم مطوري قوقل</a>', 'at-studio-auth'); ?></li>
                        <li><?php _e('أنشئ معرف عميل OAuth 2.0 لنوع تطبيق ويب', 'at-studio-auth'); ?></li>
                        <li><?php _e('انسخ معرف التطبيق (Client ID) والرمز السري (Client Secret) وأدخلهما في الحقول أعلاه', 'at-studio-auth'); ?></li>
                        <li><?php printf(__('أضف رابط إعادة التوجيه (Redirect URI) التالي: <code>%s/?action=google-callback</code>', 'at-studio-auth'), site_url()); ?></li>
                        <li><?php _e('احفظ الإعدادات', 'at-studio-auth'); ?></li>
                    </ol>
                    
                <h3><?php _e('استكشاف الأخطاء وإصلاحها', 'at-studio-auth'); ?></h3>
                <ul>
                    <li><?php _e('تأكد من تفعيل واجهة برمجة التطبيقات (API) في وحدة تحكم مطوري قوقل', 'at-studio-auth'); ?></li>
                    <li><?php _e('تأكد من تطابق روابط إعادة التوجيه تماماً مع ما تم إدخاله في وحدة التحكم', 'at-studio-auth'); ?></li>
                    <li><?php _e('إذا لم تظهر أزرار المصادقة في صفحة تسجيل الدخول، تأكد من تفعيل الإضافة', 'at-studio-auth'); ?></li>
                    <li><?php _e('لإضافة أزرار المصادقة في أي مكان، استخدم الرمز القصير: [at_studio_auth_buttons]', 'at-studio-auth'); ?></li>
                </ul>
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * عرض قسم Discord
     */
    public function render_discord_section() {
        echo '<p>أدخل بيانات تطبيق Discord الخاص بك. <a href="https://discord.com/developers/applications" target="_blank">إنشاء تطبيق جديد</a></p>';
    }

    /**
     * عرض قسم Google
     */
    public function render_google_section() {
        echo '<p>أدخل بيانات تطبيق Google الخاص بك. <a href="https://console.developers.google.com/" target="_blank">إنشاء تطبيق جديد</a></p>';
    }

    /**
     * عرض حقل معرف تطبيق Discord
     */
    public function render_discord_client_id_field() {
        $value = get_option('at_studio_discord_client_id', '');
        echo '<input type="text" name="at_studio_discord_client_id" value="' . esc_attr($value) . '" class="regular-text">';
    }

    /**
     * عرض حقل الرمز السري لتطبيق Discord
     */
    public function render_discord_client_secret_field() {
        $value = get_option('at_studio_discord_client_secret', '');
        echo '<input type="password" name="at_studio_discord_client_secret" value="' . esc_attr($value) . '" class="regular-text">';
    }

    /**
     * عرض حقل معرف تطبيق Google
     */
    public function render_google_client_id_field() {
        $value = get_option('at_studio_google_client_id', '');
        echo '<input type="text" name="at_studio_google_client_id" value="' . esc_attr($value) . '" class="regular-text">';
    }

    /**
     * عرض حقل الرمز السري لتطبيق Google
     */
    public function render_google_client_secret_field() {
        $value = get_option('at_studio_google_client_secret', '');
        echo '<input type="password" name="at_studio_google_client_secret" value="' . esc_attr($value) . '" class="regular-text">';
    }
    
    /**
     * عرض قسم الحماية
     */
    public function render_security_section() {
        echo '<p>أدخل بيانات reCAPTCHA الخاص بك لحماية النظام من الهجمات. <a href="https://www.google.com/recaptcha/admin" target="_blank">الحصول على مفاتيح reCAPTCHA</a></p>';
    }
    
    /**
     * عرض حقل مفتاح موقع reCAPTCHA
     */
    public function render_recaptcha_site_key_field() {
        $value = get_option('at_studio_recaptcha_site_key', '');
        echo '<input type="text" name="at_studio_recaptcha_site_key" value="' . esc_attr($value) . '" class="regular-text">';
    }
    
    /**
     * عرض حقل المفتاح السري reCAPTCHA
     */
    public function render_recaptcha_secret_key_field() {
        $value = get_option('at_studio_recaptcha_secret_key', '');
        echo '<input type="password" name="at_studio_recaptcha_secret_key" value="' . esc_attr($value) . '" class="regular-text">';
    }
    
    /**
     * عرض حقل إخفاء أزرار المصادقة في صفحة تسجيل الدخول
     */
    public function render_hide_login_buttons_field() {
        $value = get_option('at_studio_hide_login_buttons', false);
        echo '<label><input type="checkbox" name="at_studio_hide_login_buttons" value="1" ' . checked(1, $value, false) . '> ' . __('إخفاء أزرار المصادقة في صفحة تسجيل الدخول الرئيسية', 'at-studio-auth') . '</label>';
        echo '<p class="description">' . __('سيؤدي هذا إلى إخفاء أزرار المصادقة من صفحة تسجيل الدخول الافتراضية، مما يتيح لك استخدام الرمز القصير [at_studio_auth_buttons] لوضع الأزرار في أي مكان تريده', 'at-studio-auth') . '</p>';
    }
    
    /**
     * عرض قسم التحكم الفردي
     */
    public function render_control_section() {
        echo '<p>التحكم في إظهار أو إخفاء أزرار المصادقة بشكل منفصل، وإدارة خيارات استيراد الصور الشخصية.</p>';
    }
    
    /**
     * عرض حقل إخفاء زر Discord
     */
    public function render_hide_discord_button_field() {
        $value = get_option('at_studio_hide_discord_button', false);
        echo '<label><input type="checkbox" name="at_studio_hide_discord_button" value="1" ' . checked(1, $value, false) . '> ' . __('إخفاء زر Discord', 'at-studio-auth') . '</label>';
        echo '<p class="description">' . __('سيؤدي هذا إلى إخفاء زر Discord من أزرار المصادقة', 'at-studio-auth') . '</p>';
    }
    
    /**
     * عرض حقل إخفاء زر Google
     */
    public function render_hide_google_button_field() {
        $value = get_option('at_studio_hide_google_button', false);
        echo '<label><input type="checkbox" name="at_studio_hide_google_button" value="1" ' . checked(1, $value, false) . '> ' . __('إخفاء زر Google', 'at-studio-auth') . '</label>';
        echo '<p class="description">' . __('سيؤدي هذا إلى إخفاء زر Google من أزرار المصادقة', 'at-studio-auth') . '</p>';
    }
    
    /**
     * عرض حقل استيراد الصورة الشخصية
     */
    public function render_import_avatar_field() {
        $value = get_option('at_studio_import_avatar', true);
        echo '<label><input type="checkbox" name="at_studio_import_avatar" value="1" ' . checked(1, $value, false) . '> ' . __('استيراد الصورة الشخصية تلقائياً', 'at-studio-auth') . '</label>';
        echo '<p class="description">' . __('سيؤدي هذا إلى استيراد الصورة الشخصية من Discord أو Google وحفظها في الملف الشخصي للمستخدم', 'at-studio-auth') . '</p>';
    }
}

// تهيئة صفحة الإعدادات
new AT_Studio_Auth_Settings();
