<?php
/**
 * Plugin Name: AT Studio - Discord & Google Authentication
 * Description: نظام مصادقة Discord و Google لـ WordPress - تم صنع من خلال AT STUDIO
 * Version: 1.0.4
 * Author: AT Studio
 * Author URI: https://atstudio.online
 * License: GPLv2 or later
 * Text Domain: at-studio-auth
 * Tested up to: 6.5
 * Stable tag: 1.0.4
 */

// تسجيل الإضافة وتكوينها الأساسي
defined('ABSPATH') || exit;

// تحميل نطاق النص للترجمة
function at_studio_auth_load_textdomain() {
    load_plugin_textdomain('at-studio-auth', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}
add_action('plugins_loaded', 'at_studio_auth_load_textdomain');

// تضمين ملفات المصادقة
require_once plugin_dir_path(__FILE__) . 'includes/discord-auth.php';
require_once plugin_dir_path(__FILE__) . 'includes/google-auth.php';
require_once plugin_dir_path(__FILE__) . 'includes/avatar-importer.php';

// تضمين لوحة الإدارة
require_once plugin_dir_path(__FILE__) . 'admin/admin-settings.php';

// إنشاء رمز اختصار لأزرار المصادقة
function at_studio_auth_buttons_shortcode() {
    ob_start();
    at_studio_auth_buttons();
    return ob_get_clean();
}
add_shortcode('at_studio_auth_buttons', 'at_studio_auth_buttons_shortcode');

// إضافة أزرار المصادقة في صفحة تسجيل الدخول
function at_studio_auth_buttons() {
    // التحقق مما إذا كان يجب إظهار الأزرار
    $hide_on_login = get_option('at_studio_hide_login_buttons', false);
    if ($hide_on_login && in_array($GLOBALS['pagenow'], ['wp-login.php'])) {
        return;
    }
    
    $discord_auth = new AT_Studio_Discord_Auth();
    $google_auth = new AT_Studio_Google_Auth();
    
    // التحقق من إخفاء الأزرار الفردية
    $hide_discord = get_option('at_studio_hide_discord_button', false);
    $hide_google = get_option('at_studio_hide_google_button', false);
    
    // إظهار CAPTCHA فقط بعد 3 محاولات فاشلة
    $show_captcha = false;
    $recaptcha_site_key = get_option('at_studio_recaptcha_site_key', '');
    
    if (isset($_COOKIE['at_studio_failed_logins']) && 
        intval($_COOKIE['at_studio_failed_logins']) >= 3 && 
        !empty($recaptcha_site_key)) {
        $show_captcha = true;
    }
    ?>
    <div style="margin: 20px 0; text-align: center;">
        <?php if ($show_captcha) : ?>
            <div style="margin-bottom: 15px;">
                <div class="g-recaptcha" data-sitekey="<?php echo esc_attr($recaptcha_site_key); ?>"></div>
            </div>
        <?php endif; ?>
        
        <?php if (!$hide_discord) : ?>
        <a href="<?php echo $discord_auth->get_auth_url(); ?>" style="background: #5865F2; color: white; padding: 12px 24px; text-decoration: none; border-radius: 6px; display: inline-flex; align-items: center; margin: 8px; font-weight: 500; transition: all 0.3s ease; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            <svg width="20" height="20" viewBox="0 0 24 24" style="margin-left: 8px;" fill="currentColor">
                <path d="M18.942 5.556a16.299 16.299 0 0 0-4.126-1.297c-.178.321-.385.754-.529 1.097a15.175 15.175 0 0 0-4.573 0 11.583 11.583 0 0 0-.535-1.097 16.274 16.274 0 0 0-4.129 1.3c-2.611 3.946-3.319 7.794-2.965 11.587a16.494 16.494 0 0 0 5.061 2.593 12.65 12.65 0 0 0 1.084-1.785 10.689 10.689 0 0 1-1.707-.831c.143-.106.283-.217.418-.331 3.291 1.539 6.866 1.539 10.118 0 .137.114.277.225.418.331-.541.326-1.114.606-1.71.832a12.52 12.52 0 0 0 1.084 1.785 16.46 16.46 0 0 0 5.064-2.595c.453-4.396-.826-8.215-2.973-11.589zm-11.01 9.404c-.994 0-1.8-.922-1.8-2.045s.795-2.047 1.8-2.047 1.8.923 1.8 2.047c.001 1.123-.794 2.045-1.8 2.045zm6.006 0c-.994 0-1.8-.922-1.8-2.045s.795-2.047 1.8-2.047 1.8.923 1.8 2.047c0 1.123-.795 2.045-1.8 2.045z"/>
            </svg>
            <?php _e('تسجيل الدخول عبر دسكورد', 'at-studio-auth'); ?>
        </a>
        <?php endif; ?>
        
        <?php if (!$hide_google) : ?>
        <a href="<?php echo $google_auth->get_auth_url(); ?>" style="background: #4285F4; color: white; padding: 12px 24px; text-decoration: none; border-radius: 6px; display: inline-flex; align-items: center; margin: 8px; font-weight: 500; transition: all 0.3s ease; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            <svg width="20" height="20" viewBox="0 0 24 24" style="margin-left: 8px;" fill="currentColor">
                <path d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z" fill="#4285F4"/>
                <path d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z" fill="#34A853"/>
                <path d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z" fill="#FBBC05"/>
                <path d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z" fill="#EA4335"/>
            </svg>
            <?php _e('تسجيل الدخول عبر قوقل', 'at-studio-auth'); ?>
        </a>
        <?php endif; ?>
    </div>
    <style>
        .at-studio-auth-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }
    </style>
    <?php
}
add_action('login_form', 'at_studio_auth_buttons');

// تتبع محاولات تسجيل الدخول الفاشلة
function at_studio_track_failed_login($username) {
    $failed_logins = isset($_COOKIE['at_studio_failed_logins']) ? intval($_COOKIE['at_studio_failed_logins']) : 0;
    setcookie('at_studio_failed_logins', $failed_logins + 1, time() + 3600, '/');
}
add_action('wp_login_failed', 'at_studio_track_failed_login');

// إعادة تعيين العداد بعد تسجيل دخول ناجح
function at_studio_reset_failed_logins($user_login, $user) {
    setcookie('at_studio_failed_logins', '0', time() - 3600, '/');
}
add_action('wp_login', 'at_studio_reset_failed_logins', 10, 2);

// معالجة رد مصادقة Discord
function at_studio_handle_discord_callback() {
    if (isset($_GET['action']) && $_GET['action'] === 'discord-callback') {
        if (isset($_GET['code'])) {
            $discord_auth = new AT_Studio_Discord_Auth();
            $user_data = $discord_auth->handle_callback($_GET['code']);
            if ($user_data) {
                $discord_auth->login_or_register_user($user_data);
                wp_redirect(admin_url());
                exit;
            }
        }
        // في حالة الخطأ، إعادة التوجيه إلى صفحة تسجيل الدخول
        wp_redirect(wp_login_url());
        exit;
    }
}
add_action('init', 'at_studio_handle_discord_callback');

// معالجة رد مصادقة Google
function at_studio_handle_google_callback() {
    if (isset($_GET['action']) && $_GET['action'] === 'google-callback') {
        if (isset($_GET['code'])) {
            $google_auth = new AT_Studio_Google_Auth();
            $user_data = $google_auth->handle_callback($_GET['code']);
            if ($user_data) {
                $google_auth->login_or_register_user($user_data);
                wp_redirect(admin_url());
                exit;
            }
        }
        // في حالة الخطأ، إعادة التوجيه إلى صفحة تسجيل الدخول
        wp_redirect(wp_login_url());
        exit;
    }
}
add_action('init', 'at_studio_handle_google_callback');

// إضافة شعار AT Studio
function at_studio_auth_footer() {
    $logo_url = plugins_url('assets/at-studio-logo.png', __FILE__);
    $logo_path = plugin_dir_path(__FILE__) . 'assets/at-studio-logo.png';
    
    echo '<div style="text-align:center;margin-top:20px;font-size:12px;">';
    
    if (file_exists($logo_path)) {
        echo '<img src="' . $logo_url . '" alt="AT Studio" width="100">';
    } else {
        echo '<div style="background:#007bff;color:white;padding:10px;display:inline-block;border-radius:4px;">';
        echo 'AT STUDIO';
        echo '</div>';
    }
    
    echo '<p>'.__('نظام المصادقة تم تطويره بواسطة', 'at-studio-auth').' <a href="https://atstudio.online" target="_blank">'.__('AT Studio', 'at-studio-auth').'</a></p>';
    echo '</div>';
}
add_action('login_footer', 'at_studio_auth_footer');

// تحميل سكريبت reCAPTCHA
function at_studio_enqueue_recaptcha_script() {
    $recaptcha_site_key = get_option('at_studio_recaptcha_site_key', '');
    if (!empty($recaptcha_site_key)) {
        wp_enqueue_script('google-recaptcha', 'https://www.google.com/recaptcha/api.js', [], null, true);
    }
}
add_action('login_enqueue_scripts', 'at_studio_enqueue_recaptcha_script');
